/* 865patch - a hack to overcome a limitation in some i865-based computers */
/*          - based on 855patch */
/* Version 0.2 */

/* usage: 865patch size [nocheck]*/
/*        size is the the new VideoRAM size in kB */
/*        add nocheck if you get a segmentation fault otherwise */

/* This source code is in the public domain. Please mention me, if you use */
/* this code in your work. */
/* This version should be quite safe to use, but don't blame me  */
/* if something bad happens. */

/* Christian Zietz <czietz@gmx.net> */
/* changes for i865 contributed by Marc Seil */

#include <stdio.h>
#include <stdlib.h>
#include <sys/io.h>
#include <unistd.h>
#define __USE_GNU
#include <string.h>
#include <sys/mman.h>
#include <fcntl.h>

// these files come from lrmi
#include <lrmi.h>
#include <vbe.h>

#define vbiosaddr 0xc0000
#define vbiossize 0x10000
#define chipsetid 0x25708086
#define idstring "Total time for VGA POST:"
#define idoffset (-23)

int main (int argc, char *argv[]) {
  int newmemsize;
  int check;
  int result;

  int oldpam;
  char *biosmemptr;
  int memfd = 0;

  struct LRMI_regs r;
  struct vbe_info_block *info;

  if (argc<2) {
    fprintf(stderr, "Usage: %s size [nocheck]\nsize is new VideoRAM size in kB\nadd nocheck if you get a segmentation fault otherwise\n", argv[0]);
    return 1;
  }
  
  newmemsize = atoi(argv[1]);
  if (newmemsize==0) {
    fprintf(stderr, "Usage: %s size [nocheck]\nsize is new VideoRAM size in kB\nadd nocheck if you get a segmentation fault otherwise\n", argv[0]);
    return 1;
  }

  if (argc==3) {
    check = strcmp(argv[2], "nocheck");
  } else {
    check = 1;
  }
  
  // give me permission to access io ports
  if (iopl(3)<0) {
    fprintf(stderr, "Could not set IO permissions!\n%s must be run as root\n", argv[0]);
    return 1;
  }

  // check for correct chipset
  outl(0x80000000, 0xcf8);
  if (inl(0xcfc) != chipsetid) {
    fprintf(stderr, "No i865 chipset found!\n");
    return 1;
  }
  printf("i865 chipset found\n");

  // access the Video BIOS
  memfd = open("/dev/mem", O_RDWR);
  if (memfd<0) {
    fprintf(stderr, "Could not open /dev/mem !\n");
    return 1;
  }

  biosmemptr = mmap((void *)vbiosaddr, vbiossize, PROT_READ | PROT_WRITE, MAP_SHARED | MAP_FIXED, memfd, vbiosaddr);
  if (biosmemptr == NULL) {
    fprintf(stderr, "Could not mmap Video BIOS!\n");
    close(memfd);
    return 1;
  }

  // search for ID string and calculate address to patch
  biosmemptr = memmem(biosmemptr, vbiossize, idstring, strlen(idstring));
  if(biosmemptr == NULL) {
    fprintf(stderr, "Unsupported Video BIOS!\n");
    munmap(biosmemptr, vbiossize);
    close(memfd);
    return 1;
  }

  biosmemptr += idoffset;

  if (check) {
    printf("If you get a segmentation fault, call: %s %s nocheck\n",argv[0],argv[1]);
    // call BIOS and check returned memory size with that stored at the location to patch
    LRMI_init();
    info = LRMI_alloc_real(sizeof(struct vbe_info_block));
    if (info == NULL) {
      fprintf(stderr, "Could not allocate real mode memory!\n");
      munmap(biosmemptr, vbiossize);
      close(memfd);
      return 1;
    } 
   
    memset(&r, 0, sizeof(r));
    r.eax = 0x4f00;
    r.es = (unsigned int)info >> 4;
    r.edi = (unsigned int)info & 0xf;
    LRMI_int(0x10, &r);
    if (r.eax != 0x004f) {
      fprintf(stderr, "VBE call failed!\n");
      LRMI_free_real(info);
      munmap(biosmemptr, vbiossize);
      close(memfd);
      return 1;
    }

    // verify value at location to patch (rounded down) and value returned by BIOS match
    if ((*(long *)biosmemptr - 0x21000) >> 16 != info->total_memory) {
      fprintf(stderr, "Could not calculate correct location to patch!\n");
      LRMI_free_real(info);
      munmap(biosmemptr, vbiossize);
      close(memfd);
      return 1;
    }
    LRMI_free_real(info);
  } else {
    printf("\nWarning: Not checking calculated location. Assuming it to be right.\nThis is unsafe!\n\n");
  }

  // set permissions to read and write so I can write into shadowed VideoBIOS
  outl(0x80000090, 0xcf8);
  oldpam = inw(0xcfe);
  outl(0x80000090, 0xcf8);
  outw(0x3333, 0xcfe);

  // patch it
  printf("BIOS currently knows of %ld kB of VideoRAM\n", *(long *)biosmemptr/1024);  
  *(long *)biosmemptr = newmemsize*1024;
  result = *(long *)biosmemptr/1024==newmemsize;
  printf("%s setting size to %d kB\n", (result)?"Successfully":"Unsuccessfully", newmemsize);  

  // reset permissions
  outl(0x80000090, 0xcf8);
  outw(oldpam, 0xcfe);  

  munmap(biosmemptr, vbiossize);
  close(memfd);

  return !result;
}
